<?php
// JEDI Security • bulk_download.php
// POST 'files' as JSON array of relative paths: ["2026/01/a.png","2026/01/b.pdf"]
// Returns a ZIP attachment.

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo "POST only.";
  exit;
}

$raw = $_POST['files'] ?? '';
if ($raw === '') {
  http_response_code(400);
  echo "Missing files.";
  exit;
}

$files = json_decode($raw, true);
if (!is_array($files) || count($files) === 0) {
  http_response_code(400);
  echo "Bad files payload.";
  exit;
}

$tmp = tempnam(sys_get_temp_dir(), 'jedi_zip_');
$zipPath = $tmp . '.zip';
@unlink($tmp);

$zip = new ZipArchive();
if ($zip->open($zipPath, ZipArchive::CREATE) !== true) {
  http_response_code(500);
  echo "Cannot create zip.";
  exit;
}

$base = __DIR__ . '/uploads/';
$added = 0;

foreach ($files as $rel) {
  if (!is_string($rel)) continue;
  $rel = str_replace('\\','/',$rel);
  if ($rel === '' || strpos($rel,'..') !== false || str_starts_with($rel,'/')) continue;

  $full = $base . $rel;
  if (!is_file($full)) continue;

  // Put in zip under its relative path
  $zip->addFile($full, $rel);
  $added++;
}

$zip->close();

if ($added === 0) {
  @unlink($zipPath);
  http_response_code(400);
  echo "No valid files to zip.";
  exit;
}

$dlName = 'jedi_uploads_' . date('Ymd_His') . '.zip';
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="'.$dlName.'"');
header('Content-Length: ' . filesize($zipPath));
header('X-Content-Type-Options: nosniff');

readfile($zipPath);
@unlink($zipPath);
