<?php
// JEDI Security • download.php
// Forces attachment download for a stored file.
// Usage: download.php?path=YYYY/MM/filename.ext

$rel = $_GET['path'] ?? '';
$rel = str_replace('\\', '/', $rel);

// basic traversal protection
if ($rel === '' || strpos($rel, '..') !== false || str_starts_with($rel, '/')) {
  http_response_code(400);
  echo "Bad path.";
  exit;
}

$full = __DIR__ . '/uploads/' . $rel;
if (!is_file($full)) {
  http_response_code(404);
  echo "Not found.";
  exit;
}

$filename = basename($full);
$size = filesize($full);
$mime = 'application/octet-stream';
$finfo = finfo_open(FILEINFO_MIME_TYPE);
if ($finfo) {
  $m = finfo_file($finfo, $full);
  if ($m) $mime = $m;
  finfo_close($finfo);
}

header('Content-Type: '.$mime);
header('Content-Length: '.$size);
header('Content-Disposition: attachment; filename="'.addslashes($filename).'"');
header('X-Content-Type-Options: nosniff');

readfile($full);
