<?php
// JEDI Security • Upload handler (AJAX-friendly)
// No SQL. No overwrite. Randomized names. Date folders.

header('Content-Type: application/json; charset=utf-8');

function respond($ok, $payload = []) {
  echo json_encode(array_merge(['ok'=>$ok], $payload), JSON_UNESCAPED_SLASHES);
  exit;
}

if (!isset($_FILES['file'])) {
  respond(false, ['error'=>'No file received.']);
}

$maxBytes = 1024 * 1024 * 1024 * 2; // 2 GB default. Adjust if needed.
if ($_FILES['file']['error'] !== UPLOAD_ERR_OK) {
  respond(false, ['error'=>'Upload error code: '.$_FILES['file']['error']]);
}
if ($_FILES['file']['size'] <= 0) {
  respond(false, ['error'=>'Empty file.']);
}
if ($_FILES['file']['size'] > $maxBytes) {
  respond(false, ['error'=>'File too large. Max: '.number_format($maxBytes).' bytes.']);
}

$origName = $_FILES['file']['name'] ?? 'file';
$origName = preg_replace('/[^\w\.\- ]+/u', '_', $origName);
$ext = strtolower(pathinfo($origName, PATHINFO_EXTENSION));

// Block executable / risky types (extend as needed)
$blocked = [
  'php','phtml','php3','php4','php5','phar','cgi','pl','py','rb','sh','bash','zsh',
  'js','jsx','ts','tsx','html','htm','shtml','xhtml','hta','asp','aspx','jsp','jar',
  'exe','dll','bat','cmd','com','msi','vbs','ps1','scr','reg','apk'
];

if ($ext && in_array($ext, $blocked, true)) {
  respond(false, ['error'=>'Blocked file type: .'.$ext]);
}

// Optional MIME sniff (best-effort)
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime = $finfo ? finfo_file($finfo, $_FILES['file']['tmp_name']) : '';
if ($finfo) finfo_close($finfo);

// Create destination folder
$destDir = __DIR__ . '/uploads/' . date('Y/m') . '/';
if (!is_dir($destDir) && !mkdir($destDir, 0777, true)) {
  respond(false, ['error'=>'Failed to create upload folder.']);
}

// Randomized filename (keeps extension for convenience)
$rand = bin2hex(random_bytes(16));
$filename = $ext ? ($rand.'.'.$ext) : $rand;
$destPath = $destDir . $filename;

if (!move_uploaded_file($_FILES['file']['tmp_name'], $destPath)) {
  respond(false, ['error'=>'Failed to move uploaded file.']);
}

// Build public link
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$publicPath = 'uploads/' . date('Y/m') . '/' . $filename;
$link = $scheme . $host . '/' . $publicPath;

respond(true, [
  'link' => $link,
  'name' => $origName,
  'mime' => $mime,
  'bytes' => (int)$_FILES['file']['size']
]);
