<?php
$active = "contact";
$page_title = "Contact — Jedi Security";
$description = "Minimal contact vectors and routing.";
require __DIR__ . '/includes/header.php';
?>
<section class="hero">
  <div class="kicker">CONTACT</div>
  <h1 class="h1">Minimal, by design.</h1>
  <p class="sub">
    This site intentionally avoids forms, trackers, and user input. Use routing nodes below.
  </p>
</section>

<section class="section">
  <div class="section__title">
    <h2 class="h2">Routing</h2>
    <div class="tiny tiny--muted">External destinations.</div>
  </div>

  <div class="grid">
    <div class="card">
      <div class="card__head">
        <h3 class="card__title">Linktree</h3>
        <span class="badge">external</span>
      </div>
      <p class="card__desc">Public routing hub.</p>
      <div class="card__foot">
        <a class="link" href="<?= htmlspecialchars($links['linktree'], ENT_QUOTES) ?>" target="_blank" rel="noopener">Open ↗</a>
        <span class="tiny tiny--muted">Linktree</span>
      </div>
    </div>

    <div class="card">
      <div class="card__head">
        <h3 class="card__title">Archive Search</h3>
        <span class="badge">cloud</span>
      </div>
      <p class="card__desc">Search node for distributed archives.</p>
      <div class="card__foot">
        <a class="link" href="<?= htmlspecialchars($links['archive_search'], ENT_QUOTES) ?>" target="_blank" rel="noopener">Open ↗</a>
        <span class="tiny tiny--muted">jedi-sec.cloud</span>
      </div>
    </div>

    <div class="card">
      <div class="card__head">
        <h3 class="card__title">Network</h3>
        <span class="badge">local</span>
      </div>
      <p class="card__desc">Domain map + routing points.</p>
      <div class="card__foot">
        <a class="link" href="/network.php">View →</a>
        <span class="tiny tiny--muted">jedisec.me</span>
      </div>
    </div>
  </div>
</section>

<?php require __DIR__ . '/includes/footer.php'; ?>
