<?php
$active = "projects";
$page_title = "Projects — Jedi Security";
$description = "Active systems, experimental nodes, and archival routing.";
require __DIR__ . '/includes/header.php';

$projects = $links['projects'] ?? [];
?>
<section class="hero">
  <div class="kicker">PROJECTS</div>
  <h1 class="h1">Assets on the board.</h1>
  <p class="sub">A compact index of live nodes and core utilities. Archive search is centralized on the cloud node for indexing and discovery.</p>
</section>

<section class="section" id="list">
  <div class="section__title">
    <h2 class="h2">Live / Core</h2>
    <div class="tiny tiny--muted">No hype. Just function.</div>
  </div>

  <div class="grid">
    <?php foreach ($projects as $p): ?>
      <div class="card" id="<?= (isset($p['tag']) && strtolower($p['tag'])==='historical') ? 'oss' : '' ?>">
        <div class="card__head">
          <h3 class="card__title"><?= htmlspecialchars($p['name'] ?? 'Project', ENT_QUOTES) ?></h3>
          <span class="badge"><?= htmlspecialchars($p['status'] ?? 'Active', ENT_QUOTES) ?></span>
        </div>
        <p class="card__desc"><?= htmlspecialchars($p['desc'] ?? '', ENT_QUOTES) ?></p>
        <div class="card__foot">
          <a class="link" href="<?= htmlspecialchars($p['url'] ?? '#', ENT_QUOTES) ?>" target="_blank" rel="noopener">Open ↗</a>
          <span class="tiny tiny--muted"><?= htmlspecialchars($p['tag'] ?? '', ENT_QUOTES) ?></span>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<hr class="sep">

<section class="section">
  <div class="section__title">
    <h2 class="h2">Add / Edit Projects</h2>
    <div class="tiny tiny--muted">Single-file update.</div>
  </div>

  <div class="item">
    <p class="sub" style="margin:0;">
      Edit <span class="badge">/config/links.php</span> to update project cards and outbound routes.
      This site intentionally has no admin panel, no logins, no database.
    </p>
  </div>
</section>

<?php require __DIR__ . '/includes/footer.php'; ?>
