<?php
$active = "home";
$page_title = "Jedi Security — Cryo‑Matrix";
$description = "Independent systems, archival intelligence, and digital resilience.";
require __DIR__ . '/includes/header.php';
?>
<section class="hero">
  <div class="kicker">CRYO‑MATRIX NODE</div>
  <h1 class="h1">Independent systems,<br>archival intelligence,<br>digital resilience.</h1>
  <p class="sub">
    This node is the front door: identity, direction, and stable routing to the network.
    Archive search and indexing live on our cloud node for permanence and speed.
  </p>

  <div class="hero__cta">
    <a class="btn" href="/projects.php">View Projects</a>
    <a class="btn btn--ghost" href="<?= htmlspecialchars($links['archive_search'], ENT_QUOTES) ?>" target="_blank" rel="noopener">Search the Archive ↗</a>
    <a class="btn btn--ghost" href="/network.php">Network Map</a>
  </div>
</section>

<section class="section">
  <div class="section__title">
    <h2 class="h2">Quick Links</h2>
    <div class="tiny tiny--muted">Clean routing. No clutter.</div>
  </div>

  <div class="grid">
    <div class="card">
      <div class="card__head">
        <h3 class="card__title">Archive Search</h3>
        <span class="badge">jedi‑sec.cloud</span>
      </div>
      <p class="card__desc">
        Distributed archive indexing + search. OSS historical materials route through this node for lookup.
      </p>
      <div class="card__foot">
        <a class="link" href="<?= htmlspecialchars($links['archive_search'], ENT_QUOTES) ?>" target="_blank" rel="noopener">Open Search ↗</a>
        <span class="tiny tiny--muted">External</span>
      </div>
    </div>

    <div class="card">
      <div class="card__head">
        <h3 class="card__title">Projects</h3>
        <span class="badge">active</span>
      </div>
      <p class="card__desc">
        A compact list of what’s live, what’s experimental, and what’s archived.
      </p>
      <div class="card__foot">
        <a class="link" href="/projects.php">Browse Projects →</a>
        <span class="tiny tiny--muted">Local</span>
      </div>
    </div>

    <div class="card">
      <div class="card__head">
        <h3 class="card__title">Network</h3>
        <span class="badge">domains</span>
      </div>
      <p class="card__desc">
        Domains under operation, mirrors, and routing points across the constellation.
      </p>
      <div class="card__foot">
        <a class="link" href="/network.php">View Network →</a>
        <span class="tiny tiny--muted">Local</span>
      </div>
    </div>
  </div>
</section>

<section class="section">
  <div class="section__title">
    <h2 class="h2">OSS (Historical)</h2>
    <div class="tiny tiny--muted">Archive access lives on the cloud node.</div>
  </div>

  <div class="card" style="grid-column: span 12;">
    <div class="card__head">
      <h3 class="card__title">OSS Archive Routing</h3>
      <span class="badge">historical</span>
    </div>
    <p class="card__desc" style="max-width: 92ch;">
      OSS is handled here as historical archival material: preservation, indexing, and research context.
      We do not claim authority or enforcement—this is documentation and access routing.
    </p>
    <div class="card__foot">
      <a class="btn btn--ghost" href="<?= htmlspecialchars($links['archive_search'], ENT_QUOTES) ?>?q=oss" target="_blank" rel="noopener">Search “oss” ↗</a>
      <a class="btn" href="/projects.php#oss">OSS References →</a>
    </div>
  </div>
</section>

<?php require __DIR__ . '/includes/footer.php'; ?>
