<?php
$active = "network";
$page_title = "Network — Jedi Security";
$description = "Domains, mirrors, and routing across the constellation.";
require __DIR__ . '/includes/header.php';

$domains = $links['domains'] ?? [];
?>
<section class="hero">
  <div class="kicker">NETWORK</div>
  <h1 class="h1">Constellation routing.</h1>
  <p class="sub">A human-readable map of nodes. Keep jedisec.me lightweight; push indexing/search to the cloud node.</p>
</section>

<section class="section">
  <div class="section__title">
    <h2 class="h2">Domains</h2>
    <div class="tiny tiny--muted">Direct links • no iframe embeds here.</div>
  </div>

  <div class="list">
    <?php foreach ($domains as $name => $url): ?>
      <div class="item">
        <h3 class="item__title"><?= htmlspecialchars($name, ENT_QUOTES) ?></h3>
        <div class="item__meta">
          <span class="badge">node</span>
          <span>↗ <a class="link" href="<?= htmlspecialchars($url, ENT_QUOTES) ?>" target="_blank" rel="noopener"><?= htmlspecialchars($url, ENT_QUOTES) ?></a></span>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<hr class="sep">

<section class="section">
  <div class="section__title">
    <h2 class="h2">Routing Principle</h2>
    <div class="tiny tiny--muted">Boring on purpose.</div>
  </div>

  <div class="item">
    <p class="sub" style="margin:0; max-width: 90ch;">
      <strong>jedisec.me</strong> is identity + navigation. <strong>jedi-sec.cloud</strong> is archive search.
      Keep heavy systems off the front door. That’s resiliency by design.
    </p>
  </div>
</section>

<?php require __DIR__ . '/includes/footer.php'; ?>
