<?php
// index.php - simple router (no framework)
$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// Normalize
$path = rtrim($path, '/');
if ($path === '') $path = '/';

// Map routes to files
$routes = [
  '/' => __DIR__ . '/pages/home.php',
  '/charter' => __DIR__ . '/pages/charter.php',

  '/veterans' => __DIR__ . '/pages/veterans/index.php',
  '/veterans/userra' => __DIR__ . '/pages/veterans/userra.php',
  '/veterans/vevraa' => __DIR__ . '/pages/veterans/vevraa.php',
  '/veterans/federal-hiring' => __DIR__ . '/pages/veterans/federal-hiring.php',
  '/veterans/scra' => __DIR__ . '/pages/veterans/scra.php',
  '/veterans/disability-rights' => __DIR__ . '/pages/veterans/disability-rights.php',
  '/veterans/title-38' => __DIR__ . '/pages/veterans/title-38.php',

  '/internet-rights' => __DIR__ . '/pages/internet-rights/index.php',
  '/internet-rights/fair-use' => __DIR__ . '/pages/internet-rights/fair-use.php',
  '/internet-rights/dmca' => __DIR__ . '/pages/internet-rights/dmca.php',
  '/internet-rights/section-230' => __DIR__ . '/pages/internet-rights/section-230.php',
  '/internet-rights/privacy' => __DIR__ . '/pages/internet-rights/privacy.php',

  '/toolkit' => __DIR__ . '/pages/toolkit/index.php',
  '/toolkit/evidence' => __DIR__ . '/pages/toolkit/evidence.php',
  '/toolkit/timelines' => __DIR__ . '/pages/toolkit/timelines.php',
  '/toolkit/hashes' => __DIR__ . '/pages/toolkit/hashes.php',
  '/toolkit/incident-reports' => __DIR__ . '/pages/toolkit/incident-reports.php',

  '/cases' => __DIR__ . '/pages/cases/index.php',
  '/preserve' => __DIR__ . '/pages/preserve/index.php',
];

$pageFile = $routes[$path] ?? null;

require __DIR__ . '/includes/header.php';

if ($pageFile && file_exists($pageFile)) {
  require $pageFile;
} else {
  http_response_code(404);
  echo "<main class='wrap'><h1>404</h1><p>That page doesn’t exist.</p><p><a class='btn' href='/'>Go home</a></p></main>";
}

require __DIR__ . '/includes/footer.php';
