(() => {
  const btn = document.getElementById('navbtn');
  const menu = document.getElementById('navmobile');
  if (btn && menu) {
    btn.addEventListener('click', () => {
      const open = !menu.hasAttribute('hidden');
      if (open) {
        menu.setAttribute('hidden', '');
        btn.setAttribute('aria-expanded', 'false');
      } else {
        menu.removeAttribute('hidden');
        btn.setAttribute('aria-expanded', 'true');
      }
    });
  }

  // Minimal ambient motion (respects reduced motion).
  const prefersReduced = window.matchMedia && window.matchMedia('(prefers-reduced-motion: reduce)').matches;
  if (prefersReduced) return;

  // Create a tiny "matrix drift" particle layer using DOM (lightweight).
  const layer = document.createElement('div');
  layer.setAttribute('aria-hidden', 'true');
  layer.style.position = 'fixed';
  layer.style.inset = '0';
  layer.style.pointerEvents = 'none';
  layer.style.zIndex = '-1';
  layer.style.opacity = '0.28';
  document.body.appendChild(layer);

  const chars = "01";
  const count = Math.min(60, Math.floor(window.innerWidth / 18));
  for (let i = 0; i < count; i++) {
    const s = document.createElement('span');
    s.textContent = chars[Math.floor(Math.random()*chars.length)];
    s.style.position = 'absolute';
    s.style.left = Math.random()*100 + 'vw';
    s.style.top = (-10 - Math.random()*90) + 'vh';
    s.style.fontFamily = '"JetBrains Mono", ui-monospace, monospace';
    s.style.fontSize = (10 + Math.random()*10) + 'px';
    s.style.color = 'rgba(0,255,123,0.9)';
    s.style.textShadow = '0 0 10px rgba(0,255,123,0.35)';
    s.style.filter = 'blur(0px)';
    s.style.userSelect = 'none';
    const dur = 6 + Math.random()*10;
    s.animate([
      { transform: 'translateY(0px)', opacity: 0.0 },
      { opacity: 0.55, offset: 0.15 },
      { transform: `translateY(${110 + Math.random()*40}vh)`, opacity: 0.0 }
    ], { duration: dur*1000, iterations: Infinity, delay: Math.random()*2000 });
    layer.appendChild(s);
  }
})();
