<?php
$links = require __DIR__ . '/../config/links.php';
$site_name = "Jedi Security";
$active = $active ?? "";
$page_title = $page_title ?? $site_name;
$description = $description ?? "Independent systems, archival intelligence, and digital resilience.";
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="theme-color" content="#020B08">
  <meta name="description" content="<?= htmlspecialchars($description, ENT_QUOTES) ?>">
  <title><?= htmlspecialchars($page_title, ENT_QUOTES) ?></title>

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;600;700&family=Inter:wght@400;600;700&display=swap" rel="stylesheet">

  <link rel="stylesheet" href="/assets/css/style.css?v=1">
</head>
<body>
  <div class="bg-ambient" aria-hidden="true"></div>
  <div class="bg-grid" aria-hidden="true"></div>

  <header class="topbar">
    <div class="wrap topbar__inner">
      <a class="brand" href="/index.php" aria-label="Home">
        <span class="brand__mark">JS</span>
        <span class="brand__name"><?= htmlspecialchars($site_name, ENT_QUOTES) ?></span>
      </a>

      <nav class="nav">
        <a class="nav__link <?= $active==='home'?'is-active':'' ?>" href="/index.php">Home</a>
        <a class="nav__link <?= $active==='projects'?'is-active':'' ?>" href="/projects.php">Projects</a>
        <a class="nav__link <?= $active==='network'?'is-active':'' ?>" href="/network.php">Network</a>
        <a class="nav__link nav__link--out" href="<?= htmlspecialchars($links['archive_search'], ENT_QUOTES) ?>" target="_blank" rel="noopener">Archive Search ↗</a>
        <a class="nav__link <?= $active==='contact'?'is-active':'' ?>" href="/contact.php">Contact</a>
      </nav>

      <button class="navbtn" id="navbtn" aria-label="Menu" aria-expanded="false">
        <span></span><span></span><span></span>
      </button>
    </div>

    <div class="wrap navmobile" id="navmobile" hidden>
      <a class="navmobile__link" href="/index.php">Home</a>
      <a class="navmobile__link" href="/projects.php">Projects</a>
      <a class="navmobile__link" href="/network.php">Network</a>
      <a class="navmobile__link" href="<?= htmlspecialchars($links['archive_search'], ENT_QUOTES) ?>" target="_blank" rel="noopener">Archive Search ↗</a>
      <a class="navmobile__link" href="/contact.php">Contact</a>
    </div>
  </header>

  <main class="wrap main">
